local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// our color
	self.Color = Color( 0, 0, 0, 255 );
	
	// create x
	self.RSlider = CtlSlider_class:create( self );
	self.RSlider:SetText( "Red" );
	self.RSlider:SetHorizontal( true );
	self.RSlider:SetRange( 0, 255 );
	self.RSlider:SetSnap( 1 );
	self.RSlider:SetSize( 128, 32 );
	self.RSlider:SetColor( Color( 0, 0, 0, 255 ) );
	self.RSlider:AddEvent( "OnSliderMoved", "OnRed", self );
	
	// create y
	self.GSlider = CtlSlider_class:create( self );
	self.GSlider:SetText( "Green" );
	self.GSlider:SetHorizontal( true );
	self.GSlider:SetRange( 0, 255 );
	self.GSlider:SetSnap( 1 );
	self.GSlider:SetSize( 128, 32 );
	self.GSlider:SetColor( Color( 0, 0, 0, 255 ) );
	self.GSlider:AddEvent( "OnSliderMoved", "OnGreen", self );
	
	// create z
	self.BSlider = CtlSlider_class:create( self );
	self.BSlider:SetText( "Blue" );
	self.BSlider:SetHorizontal( true );
	self.BSlider:SetRange( 0, 255 );
	self.BSlider:SetSnap( 1 );
	self.BSlider:SetSize( 128, 32 );
	self.BSlider:SetColor( Color( 0, 0, 0, 255 ) );
	self.BSlider:AddEvent( "OnSliderMoved", "OnBlue", self );
	
end

// events
function PANEL:OnRed( amt )
	self.Color.r = amt;
	
	// update my sliders color
	self.RSlider:SetColor( Color( amt, 0, 0, 255 ) );
	
end

function PANEL:OnGreen( amt )
	self.Color.g = amt;
	
	// update my sliders color
	self.GSlider:SetColor( Color( 0, amt, 0, 255 ) );
	
end

function PANEL:OnBlue( amt )
	self.Color.b = amt;
	
	// update my sliders color
	self.BSlider:SetColor( Color( 0, 0, amt, 255 ) );
	
end

function PANEL:SetColor( color )
	//
	self.Color = Color( color.r, color.g, color.b, 255 );
	
	// update sliders
	self.RSlider:SetColor( Color( color.r, color.g, color.b, 255 ) );
	self.GSlider:SetColor( Color( color.r, color.g, color.b, 255 ) );
	self.BSlider:SetColor( Color( color.r, color.g, color.b, 255 ) );
	
	//
	self.RSlider:SetValue( color.r );
	self.GSlider:SetValue( color.g );
	self.BSlider:SetValue( color.b );

end


// perform layout
function PANEL:PerformLayout( )
	//
	local width = self:GetWide();
	
	// position the sliders
	self.RSlider:SetPos( 0, 0 );
	self.RSlider:SetSize( width - 96, 32 );
	
	self.GSlider:SetPos( 0, 32 );
	self.GSlider:SetSize( width - 96, 32 );
	
	self.BSlider:SetPos( 0, 64 );
	self.BSlider:SetSize( width - 96, 32 );
	
end


// draw
function PANEL:Paint( )
	//
	local width, height = self:GetSize();
	
	// frame.
	AppFramework:Theme():DrawFrame( width - 96, 0, 96, height, FRAME_INSET, self.Color );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_colorpicker_element", PANEL, "Panel" );




// create app framework control.
CtlColorPickerElement_class 	= Control_class:create( nil, false, "ctl_colorpicker_element" );

//
function CtlColorPickerElement_class:GetColor( )
	return self:GetHandle().Color;

end

//
function CtlColorPickerElement_class:SetColor( c )
	return self:GetHandle():SetColor( c );

end
